// File: char_v.cp
//
// Description: smart vector implementation for chars
//
// Copyright 1992, 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions.  All
//       source rights reserved: Source code to the GUI library
//       can not be distributed (on bulletin boards, or as part
//       of shareware or commercial products) without written
//       permission.
//

#include "char_v.h"

extern "C" { void exit(int); void sprintf(...); };

void Warning(char *);

// Define constants for the dynamic grow rate for char_vect data types and
// the maximum number of elements that a smart char_vect can have:

const long GROW_RATE = 1024;
#ifndef WINDOWS
const long MAX_SIZE = 256000;  // For Windows or DOS with
										 // 64K byte segments, make
										 // this 64000
#else
const long MAX_SIZE = 64000;  // For Windows or DOS with
										// 64K byte segments, make
										// this 64000
#endif

char_vect::char_vect(void)
{
    size = (long)64L;
    p = new char[size];
    if (p == 0) {
       Warning("Error allocating a char_vect.");
       exit(1);
    }
}

char_vect::char_vect(long n)
{
    if (n<= 0) {
        char buf[64];
        sprintf(buf,"Ilegal size for for char_vect constructor=%d",n);
        Warning(buf);
        exit(1);
    }
    size = n;
    p = new char[size];
    if (p == 0) {
       Warning("Error allocating a char_vect.");
       exit(1);
    }
}

char_vect::char_vect(char a[], long n)
{
    if (n<= 0) {
        Warning("illegal size for a char_vect");
        exit(1);
    }
    size = n;
    p = new char[size];
    for (long i=0; i<size; i++)  p[i] = a[i];
}

char_vect::char_vect(char_vect &v)
{
    size = v.size;
    p = new char[size];
    for (long i=0; i<size; i++)  p[i] = v.p[i];
}

char & char_vect::operator [] (long i)
{
    if (i < 0) {
        char buf[64];
        sprintf(buf,"Illegal size for char_vect [] operator=%d",i);
        Warning(buf);
        exit(1);
    }
    if (i > ub()) {
        grow(i);
    }
    return (p[i]);
}

void char_vect::grow(long new_size)
{
    if ((new_size + GROW_RATE) >= MAX_SIZE) {
        char buf[256];
        sprintf(buf,"Error in dynamic resizing of a smart vector. New size=%d",
                (new_size + GROW_RATE));
        Warning(buf);
        exit(1);
    }
    char *np = new char[new_size + GROW_RATE];
    for (int k=0; k<size; k++)  np[k] = p[k];
    size = (new_size + GROW_RATE);
    delete [] p;
    p = np;
}

#if 0

// test code:

main()
{
    cerr << "Start of char_vect test:\n\n";
    char_vect vv(10);
    vv[2] = 2;
    vv[220] = vv[2];  // illegal index !!
    cerr << "Done with test.\n";
}

#endif
